/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.event.EventEntityProvider;
import com.github.monun.survival.tap.event.EventTools;
import com.github.monun.survival.tap.event.HandlerStatement;
import com.github.monun.survival.tap.event.TargetEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/github/monun/survival/tap/event/ListenerStatement;", "", "listenerClass", "Ljava/lang/Class;", "handlerStatements", "Ljava/util/ArrayList;", "Lcom/github/monun/survival/tap/event/HandlerStatement;", "(Ljava/lang/Class;Ljava/util/ArrayList;)V", "Lcom/google/common/collect/ImmutableList;", "getHandlerStatements", "()Lcom/google/common/collect/ImmutableList;", "getListenerClass", "()Ljava/lang/Class;", "Companion", "api"})
public final class ListenerStatement {
    @NotNull
    private final ImmutableList<HandlerStatement> handlerStatements;
    @NotNull
    private final Class<?> listenerClass;
    private static final Map<Class<?>, ListenerStatement> STATEMENTS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ImmutableList<HandlerStatement> getHandlerStatements() {
        return this.handlerStatements;
    }

    @NotNull
    public final Class<?> getListenerClass() {
        return this.listenerClass;
    }

    public ListenerStatement(@NotNull Class<?> listenerClass, @NotNull ArrayList<HandlerStatement> handlerStatements) {
        Intrinsics.checkNotNullParameter(listenerClass, (String)"listenerClass");
        Intrinsics.checkNotNullParameter(handlerStatements, (String)"handlerStatements");
        this.listenerClass = listenerClass;
        ImmutableList immutableList = ImmutableList.copyOf((Collection)handlerStatements);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(handlerStatements)");
        this.handlerStatements = immutableList;
    }

    static {
        Companion = new Companion(null);
        STATEMENTS = new WeakHashMap();
    }

    @JvmStatic
    @NotNull
    public static final ListenerStatement getOrCreate(@NotNull Class<?> listenerClass) {
        return Companion.getOrCreate(listenerClass);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/monun/survival/tap/event/ListenerStatement$Companion;", "", "()V", "STATEMENTS", "", "Ljava/lang/Class;", "Lcom/github/monun/survival/tap/event/ListenerStatement;", "createHandlerStatement", "Lcom/github/monun/survival/tap/event/HandlerStatement;", "method", "Ljava/lang/reflect/Method;", "getOrCreate", "listenerClass", "api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ListenerStatement getOrCreate(@NotNull Class<?> listenerClass) {
            Intrinsics.checkNotNullParameter(listenerClass, (String)"listenerClass");
            Object v = STATEMENTS.computeIfAbsent(listenerClass, new Function<Class<?>, ListenerStatement>(listenerClass){
                final /* synthetic */ Class $listenerClass;

                @NotNull
                public final ListenerStatement apply(@NotNull Class<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    int mod = this.$listenerClass.getModifiers();
                    boolean bl = Modifier.isPublic(mod);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = "EntityListener modifier must be public";
                        throw (Throwable)new IllegalArgumentException(string2.toString());
                    }
                    ArrayList<HandlerStatement> handlerStatements = new ArrayList<HandlerStatement>();
                    Method[] methods = this.$listenerClass.getMethods();
                    TypeToken typeToken = TypeToken.of((Class)this.$listenerClass);
                    Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"TypeToken.of(listenerClass)");
                    Set supers = typeToken.getTypes().rawTypes();
                    block5: for (Method method : methods) {
                        Class superClass;
                        Iterator<E> iterator = supers.iterator();
                        while (iterator.hasNext() && Listener.class.isAssignableFrom(superClass = (Class)iterator.next())) {
                            try {
                                Method method2 = method;
                                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                                Class<?>[] classArray = method.getParameterTypes();
                                Method real = superClass.getDeclaredMethod(method2.getName(), Arrays.copyOf(classArray, classArray.length));
                                if (!real.isAnnotationPresent(EventHandler.class)) continue;
                                try {
                                    handlerStatements.add(com.github.monun.survival.tap.event.ListenerStatement$Companion.access$createHandlerStatement(ListenerStatement.Companion, method));
                                    continue block5;
                                }
                                catch (Exception e) {
                                    throw (Throwable)new IllegalArgumentException("Failed to create HandlerStatement for " + real);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                            catch (SecurityException securityException) {
                            }
                        }
                    }
                    return new ListenerStatement(this.$listenerClass, handlerStatements);
                }
                {
                    this.$listenerClass = clazz;
                }
            });
            Intrinsics.checkNotNullExpressionValue(v, (String)"STATEMENTS.computeIfAbse\u2026Statements)\n            }");
            return (ListenerStatement)v;
        }

        private final HandlerStatement createHandlerStatement(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean bl = parameterTypes.length == 1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl42 = false;
                String string2 = "EntityHandler methods must require a single argument: " + method;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Class<?> eventClass = parameterTypes[0];
            bl2 = Event.class.isAssignableFrom(eventClass);
            bl3 = false;
            boolean bl42 = false;
            if (!bl2) {
                boolean bl5 = false;
                StringBuilder stringBuilder = new StringBuilder().append('\'');
                Class<?> clazz = eventClass;
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"eventClass");
                String bl42 = stringBuilder.append(clazz.getName()).append("' is not event class: ").append(method).toString();
                throw (Throwable)new IllegalArgumentException(bl42.toString());
            }
            EventHandler handler = method.getAnnotation(EventHandler.class);
            Class<?> clazz = eventClass;
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"eventClass");
            Class<?> registrationClass = EventTools.getRegistrationClass(clazz);
            TargetEntity targetEntity = method.getAnnotation(TargetEntity.class);
            EventEntityProvider provider = targetEntity == null ? EventTools.findDefaultProvider(eventClass) : EventTools.getOrCreateCustomProvide(targetEntity.value());
            EventExecutor eventExecutor2 = EventExecutor.create((Method)method, eventClass.asSubclass(Event.class));
            Intrinsics.checkNotNullExpressionValue((Object)eventExecutor2, (String)"EventExecutor.create(met\u2026class(Event::class.java))");
            EventExecutor executor = eventExecutor2;
            return new HandlerStatement(eventClass, registrationClass, provider, handler.priority(), handler.ignoreCancelled(), executor);
        }

        private Companion() {
        }

        public static final /* synthetic */ HandlerStatement access$createHandlerStatement(Companion $this, Method method) {
            return $this.createHandlerStatement(method);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

